#ifndef __VM_H
#define __VM_H
                
#ifdef __cplusplus
extern "C" { 
#endif 
 
/* Latest Version */
#include "hardwarestate.h"
    
#if(IS_PC_HOST)

#include "clock.h"

typedef struct 
{
	unsigned char data[32];
} FIL;

extern unsigned char 	tempString[SIZE_OF_TEMPSTRING];
extern unsigned char    tempStringPtr;
unsigned int 			convertBCDToDecimal(unsigned int bcdValue);
unsigned int 			convertDecimalToBCD(unsigned int decValue);

#else

#include "ff.h"
#include "clock.h"

#endif
 

#if(IS_PC_HOST)

#pragma pack(push, 1)

#else

#endif

typedef struct
{ 
	unsigned char opcode;
	unsigned char type;
	union
	{   
		float			fArg;
  		unsigned char	bArg;
	 	short			nArg;
		unsigned short  uArg;
 		unsigned char	data[4];
	} arg;
	float				w;
	float				f[VM_MAX_ARGUMENTS];
	ADDRESS_TYPE 		addr;
} VM_ARGUMENT;

/* The following are the access function for cache maintenance */
unsigned char* getGlobalPtr(VIRTUAL_MACHINE* vm, unsigned short offset);
VM_RETURN_TYPE clearCache(CACHE_OBJECT* cObj, unsigned char cID, ADDRESS_TYPE size, ADDRESS_TYPE maxAddress, unsigned char* start);
VM_RETURN_TYPE initCache(CACHE_OBJECT* cObj, unsigned char mode, unsigned char cID, ADDRESS_TYPE size, ADDRESS_TYPE maxAddress, unsigned char* start, unsigned char* filename);
VM_RETURN_TYPE readCacheFromDisk(CACHE_OBJECT* cObj,  unsigned char* cStart, ADDRESS_TYPE offset, ADDRESS_TYPE endOffset);
VM_RETURN_TYPE writeCacheToDisk(CACHE_OBJECT* cObj, unsigned char* cStart, ADDRESS_TYPE offset, ADDRESS_TYPE endOffset);
VM_RETURN_TYPE readCacheByte(CACHE_OBJECT* cObj, ADDRESS_TYPE offset, unsigned char* readByte);
VM_RETURN_TYPE writeCacheByte(CACHE_OBJECT* cObj, ADDRESS_TYPE offset, unsigned char* writeByte);
VM_RETURN_TYPE readCache(CACHE_OBJECT* cObj, ADDRESS_TYPE offset, unsigned char* cStart, ADDRESS_TYPE sizeBytes);
VM_RETURN_TYPE writeCache(CACHE_OBJECT* cObj, ADDRESS_TYPE offset, unsigned char* cStart, ADDRESS_TYPE sizeBytes);
VM_RETURN_TYPE addHitMiss(CACHE_OBJECT* cObj, unsigned short hit, unsigned short miss);
VM_RETURN_TYPE getInstructionAndArgument(VIRTUAL_MACHINE* vm, ADDRESS_TYPE offset, VM_ARGUMENT* aG, unsigned char* bs);
VM_RETURN_TYPE executeInstructionVM(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE stepVM(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE saveVM(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE restoreVM(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE changeVMState(VIRTUAL_MACHINE* vm, unsigned char newState);
VM_RETURN_TYPE initVM(VIRTUAL_MACHINE* vm, unsigned char exID, ADDRESS_TYPE runStart);
VM_RETURN_TYPE resetVM(VIRTUAL_MACHINE* vm, unsigned char exID);
unsigned char disFixVM(unsigned char c); 
VM_RETURN_TYPE restartVM(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE resetVMEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven);
VM_RETURN_TYPE initVMEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven);
unsigned short findVMInEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven, unsigned char vmID);
unsigned char getFreeVMID(VIRTUAL_MACHINE_ENVIRONMENT* ven);
VM_RETURN_TYPE addVMToEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven, unsigned char vmID);
VM_RETURN_TYPE deleteVMFromEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven, unsigned char vmID);
VM_RETURN_TYPE destroyVMFiles(unsigned char exID);
VM_RETURN_TYPE destroyVM(VIRTUAL_MACHINE* vm, unsigned char exID, unsigned char);
VM_RETURN_TYPE destroyAllVM(VIRTUAL_MACHINE_ENVIRONMENT* ven, unsigned char*); 
void powerVMTimer(unsigned char on);
VM_RETURN_TYPE clearVMEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven);
unsigned char getNumVMRunning(VIRTUAL_MACHINE_ENVIRONMENT* ven);
VM_RETURN_TYPE clearCaches(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE saveCaches(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE VMEnvironmentTask(VIRTUAL_MACHINE_ENVIRONMENT* ven);
void outputCharVM(VIRTUAL_MACHINE* vm, unsigned char c);
void outputSVM(VIRTUAL_MACHINE* vm, unsigned char *s);
#if(IS_PC_HOST)
#else
void outputSROMVM(VIRTUAL_MACHINE* vm, rom const unsigned char *s);
#endif
void outputFVM(VIRTUAL_MACHINE* vm, float f, unsigned short numdec);
void outputFunctionVM(VIRTUAL_MACHINE* vm, unsigned short);
void outputCVM(VIRTUAL_MACHINE* vm, unsigned char c);
void outputUFVM(VIRTUAL_MACHINE* vm, float f, unsigned short numdec);
unsigned char* getSizeGPSVM(VIRTUAL_MACHINE* vm, unsigned short* sizeOut);
void printGPSVM(VIRTUAL_MACHINE* vm);
unsigned char newRxUART(VIRTUAL_MACHINE* vm);

#if(IS_PC_HOST)
#else
VM_RETURN_TYPE VMEnvironmentSuperTask(VIRTUAL_MACHINE_ENVIRONMENT* ven, void (*idleTask)(void));
#endif

unsigned char* outputFunctionVMToString(VIRTUAL_MACHINE *vm, unsigned char* outptr, unsigned short function);

#if(IS_PC_HOST)

#else

void showCache(CACHE_OBJECT* cObj);
void showArgument(VM_ARGUMENT* varg);
void showVM(VIRTUAL_MACHINE* vm);
void showVMEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven);

#endif

#if(IS_PC_HOST)
#else
unsigned char* igetFileNameNM(unsigned char exID, unsigned char* fileN);
unsigned int getScriptName(unsigned char* outstr, unsigned char exID, unsigned char maxChars);
#endif

void 			receiveCharVM(VIRTUAL_MACHINE*);
unsigned char* getFileNameCache(CACHE_OBJECT* cObj, unsigned char* fileN);
unsigned char* igetFileNameVM(unsigned char exID, unsigned char* fileN);
unsigned char* getFileNameVM(VIRTUAL_MACHINE* vm, unsigned char* fileN);
void autoMatchGPRMC(VIRTUAL_MACHINE* vm);

VM_RETURN_TYPE initSessionHardware(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE closeSessionHardware(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE hardwareSessionTask(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE rewindVMEnvironment(VIRTUAL_MACHINE_ENVIRONMENT* ven);

void printGPSTempStringVM(VIRTUAL_MACHINE* vm);

unsigned short fileNameGetExtension(unsigned char* fName, unsigned char* outext, unsigned short maxChars);
#if(IS_PC_HOST)
unsigned char isExtension(unsigned char* fName, unsigned short maxChars, const unsigned char* ext);
#else
unsigned char isExtension(unsigned char* fName, unsigned short maxChars, const rom unsigned char* ext);
#endif
      
void 		   	setVMTimer(unsigned short, unsigned char);
void 		   	startVMTimer(void);
void 		   	stopVMTimer(void);
unsigned char 	notEmptyCharVM(VIRTUAL_MACHINE* vm);
VM_RETURN_TYPE 	getTimeVM(VIRTUAL_MACHINE* vm, TIME_T* time);
VM_RETURN_TYPE 	getTimeVM(VIRTUAL_MACHINE* vm, TIME_T* time);
long getDurationTotalSecondsFutureArgumentVM(VIRTUAL_MACHINE* vm, TIME_T* inTime);
long getDurationTotalSecondsFutureArgument(TIME_T* inTime);
int setAlarmTimeVM(VIRTUAL_MACHINE* vm, TIME_T* sysTime);

extern VM_ARGUMENT 	 argument;
extern unsigned char fileName[VM_FILENAME_MAX];
#if(IS_PC_HOST)
#else
extern FIL		 	 fvm;
#endif
#if(IS_PC_HOST)

#pragma pack(pop)

extern unsigned short vmTimer;
VM_RETURN_TYPE clearFileCache(VIRTUAL_MACHINE* vm);

#else

extern volatile unsigned short vmTimer;

#endif


#ifdef __cplusplus
}
#endif

#endif
